﻿EQUIP.accessory.seeker = {
	getNearestEnemyName:function()
	{
		if(ENEMIES.length)
		{
			var player_p = new flash.geom.Point( PLAYER._x, PLAYER._y );
			var closest = {
				index:null,
				distance:9999
			}// closest obj
			for(var e=0; e<ENEMIES.length; e++){
				var enemy_p = new flash.geom.Point( ENEMIES[e]._x, ENEMIES[e]._y );
				var dist_p = player_p.subtract(enemy_p);
				if(dist_p.length < closest.distance){
					closest = {
						index:e,
						distance:dist_p.length
					}// closest obj
				}// if:  a closer enemy is found
			}// for:  each enemy
			return ENEMIES[closest.index]._name;		// return the instance name of the closest enemy
		}// if:  there are enemies
	},// getNearestEnemyName()
	
	
	
	makeSeekObject:function()
	{
		var seekObject = {
			weapName:null,
			enemyName:null,
			seekEnemy:function(){
				var enemy_ref = SPRITES[seekObject.enemyName];
				if(enemy_ref)
				{// if:  there's an enemy to chase
					// acellerate toward the nearest enemy
					var weap_ref = SPRITES[seekObject.weapName];
					var xDir = (weap_ref._x > enemy_ref._x) ? -1 : 1;
					var yDir = (weap_ref._y > enemy_ref._y-24) ? -1 : 1;
					weap_ref.vel.x += (weap_ref.accel *xDir);
					weap_ref.vel.y += (weap_ref.accel *yDir);
					// enforce max speed limit
					if(weap_ref.vel.x > weap_ref.maxMove)
						weap_ref.vel.x = weap_ref.maxMove;
					if(weap_ref.vel.y > weap_ref.maxMove)
						weap_ref.vel.y = weap_ref.maxMove;
					
					if(weap_ref.vel.x < -weap_ref.maxMove)
						weap_ref.vel.x = -weap_ref.maxMove;
					if(weap_ref.vel.y < -weap_ref.maxMove)
						weap_ref.vel.y = -weap_ref.maxMove;
				}// if:  there's an enemy to chase
				else
				{// if:  no enemies
					var weap_ref = SPRITES[seekObject.weapName];
					weap_ref.maxMove = 32;
					// acellerate forward
					if(Math.abs(weap_ref.vel.x) < weap_ref.maxMove)
						weap_ref.vel.x += weap_ref.accel *weap_ref.dir;
				}// if:  no enemies
			}// seekEnemy()
		}// seekObject
		return seekObject;
	},// makeSeekObject()
	
	
	
	playerSubWeapon:function( weap_ref )
	{
		if(weap_ref.weapType=="blaster"){
			var nearestEnemyname = this.getNearestEnemyName();
			if(nearestEnemyname)
			{// if:  there's an enemy to seek
				// change movement speed
				weap_ref.accel = 2;
				weap_ref.maxMove = 10;
				
				/*
				// launch in a random direction
				var rad = Math.random()*2*Math.PI;
				var randVel_p = flash.geom.Point.polar(weap_ref.maxMove, rad);
				weap_ref.vel = {
					x:randVel_p.x,
					y:randVel_p.y
				}
				*/
				// launch forward
				var dir = (PLAYER.direction=="right") ? 1 : -1;
				weap_ref.vel = {
					x: dir *weap_ref.maxMove,
					y: 0
				}// vel
				
				// create new acelleration code
				weap_ref.seek_obj = this.makeSeekObject( weap_ref );
				weap_ref.seek_obj.weapName = weap_ref._name;
				weap_ref.seek_obj.enemyName = nearestEnemyname;
				// make the subWeapon use the new acelleration function
				weap_ref.acellerate = weap_ref.seek_obj.seekEnemy;
			}// if:  there's an enemy to seek
		}// if:  blaster
	},// playerSubWeapon()
	null:null
}// ring object